<?php
/**
 * ------------------------------------------------------------
 * THEME CHILD FUNCTIONS
 * ------------------------------------------------------------
 */

/**
 * Enqueue CSS tema child
 */
function child_enqueue_styles() {
    wp_enqueue_style(
        'astra-child-theme-css',
        get_stylesheet_directory_uri() . '/style.css'
    );
}
add_action('wp_enqueue_scripts', 'child_enqueue_styles');

/**
 * Google Fonts
 */
function google_fonts() {
    wp_enqueue_style(
        'google-fonts',
        'https://fonts.googleapis.com/css2?family=Courier+Prime:ital@0;1&family=Source+Code+Pro:ital,wght@0,200..900;1,200..900&display=swap',
        false
    );
}
add_action('wp_enqueue_scripts', 'google_fonts');

/**
 * Custom Post Type: Piatti
 */
function post_type_piatti() {
    register_post_type('piatti', array(
        'taxonomies'    => array('category', 'post_tag'), // category & tag rimangono
        'labels'        => array(
            'name'               => 'Piatti',
            'singular_name'      => 'Piatto',
            'add_new'            => 'Aggiungi Nuovo Piatto',
            'add_new_item'       => 'Aggiungi Nuovo Piatto',
            'edit_item'          => 'Modifica Piatto',
            'new_item'           => 'Nuovo Piatto',
        ),
        'public'        => true,
        'has_archive'   => true,
        'show_in_rest'  => true,
        'hierarchical'  => true,
        'show_in_menu'  => true,
        'supports'      => array(
            'title',
            'editor',
            'author',
            'thumbnail',
            'excerpt',
            'trackbacks',
            'custom-fields',
            'revisions',
            'page-attributes'
        ),
    ));
}
add_action('init', 'post_type_piatti');

/**
 * Includi i CPT negli archivi di categoria/tag
 */
function category_add_cpt_to_archive($query) {
    if ((is_category() || is_tag()) && $query->is_archive() && empty($query->query_vars['suppress_filters'])) {
        $query->set('post_type', 'any');
    }
    return $query;
}
add_filter('pre_get_posts', 'category_add_cpt_to_archive');


/* ==========================================================
 *  TASSONOMIA: FASCIA DI PREZZO (checkbox) per CPT "piatti"
 * ========================================================== */

/**
 * Registra tassonomia "fascia_prezzo" con UI a checkbox (gerarchica)
 * - show_admin_column: aggiunge colonna auto in lista
 * - show_in_rest: disponibile nel block editor
 */
add_action('init', function () {
    register_taxonomy('fascia_prezzo', array('piatti'), array(
        'labels' => array(
            'name'          => 'Fasce di prezzo',
            'singular_name' => 'Fascia di prezzo',
            'search_items'  => 'Cerca fasce di prezzo',
            'all_items'     => 'Tutte le fasce di prezzo',
            'edit_item'     => 'Modifica fascia di prezzo',
            'update_item'   => 'Aggiorna fascia di prezzo',
            'add_new_item'  => 'Aggiungi nuova fascia di prezzo',
            'new_item_name' => 'Nuova fascia di prezzo',
            'menu_name'     => 'Fasce di prezzo',
        ),
        'public'            => true,
        'hierarchical'      => true,          // <-- checkbox in editor e quick edit
        'show_admin_column' => true,          // colonna automatica in lista
        'show_in_rest'      => true,          // supporto block editor
        'show_ui'           => true,
        'meta_box_cb'       => 'post_categories_meta_box', // forza checklist-style
    ));

    // Crea i termini predefiniti se non esistono
    $default_terms = array(
        array('name' => '€ 9',      'slug' => 'euro-9'),
        array('name' => '€ 12-15',  'slug' => 'euro-12-15'),
        array('name' => '€ 15-20',  'slug' => 'euro-15-20'),
        array('name' => '€ 20-25',  'slug' => 'euro-20-25'),
        array('name' => '€ 35-40',  'slug' => 'euro-35-40'),
    );
    foreach ($default_terms as $t) {
        if (!term_exists($t['slug'], 'fascia_prezzo')) {
            wp_insert_term($t['name'], 'fascia_prezzo', array('slug' => $t['slug']));
        }
    }
});

/**
 * Mostra la fascia di prezzo nel single del piatto (dopo il contenuto)
 */
add_filter('the_content', function ($content) {
    if (is_singular('piatti') && in_the_loop() && is_main_query()) {
        $terms = wp_get_post_terms(get_the_ID(), 'fascia_prezzo', array('fields' => 'names'));
        if (!is_wp_error($terms) && !empty($terms)) {
            $html = '<div class="piatto-fascia-prezzo"><strong>Fascia di prezzo:</strong> ' . esc_html(implode(', ', $terms)) . '</div>';
            return $content . $html;
        }
    }
    return $content;
});