<?php
/**
 * Single template for CPT "piatti"
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 * @package Astra
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

<?php if ( astra_page_layout() === 'left-sidebar' ) : ?>
	<?php get_sidebar(); ?>
<?php endif; ?>

<div id="primary" <?php astra_primary_class(); ?>>

	<?php
	// Immagine di copertina del piatto
	$thumb_url = get_the_post_thumbnail_url( get_the_ID(), 'full' );
	?>

	<div class="contentitoregrande">
		<div class="piatto" style="background-image:url(<?php echo esc_url( $thumb_url ); ?>)"></div>

		<div class="specifiche">
			<?php
			// Pulsante "torna a tutti i piatti" (Polylang)
			if ( function_exists('pll_current_language') && pll_current_language() === 'it' ) {
				echo '<a href="https://www.mpilato.isialab.it/daalcide/ristorante-venturina-piatti/" class="bottone">Torna a tutti i piatti</a>';
			} elseif ( function_exists('pll_current_language') && pll_current_language() === 'en' ) {
				echo '<a href="#" class="bottone">See all dishes</a>';
			}
			?>

			<div class="categoriapiatto"><?php the_category(); ?></div>

			<h1 class="titolopiatto"><?php the_title(); ?></h1>

			<?php
			// CHIP fascia di prezzo (tassonomia: fascia_prezzo)
			$price_terms = wp_get_post_terms( get_the_ID(), 'fascia_prezzo' );
			if ( ! is_wp_error( $price_terms ) && ! empty( $price_terms ) ) :
				echo '<div class="piatto-prezzo-chips" aria-label="Fasce di prezzo">';
				foreach ( $price_terms as $term ) {
					$slug = sanitize_html_class( $term->slug ); // es. euro-12-15
					echo '<span class="chip-prezzo chip-prezzo--' . esc_attr( $slug ) . '">' . esc_html( $term->name ) . '</span>';
				}
				echo '</div>';
			endif;
			?>

			<div class="tagpiatto"><?php the_tags(); ?></div>

			<div class="contenuto"><?php the_content(); ?></div>
		</div>
	</div>

	<div class="contenitore">
		<div class="sinistra">
			<?php
			// Ingredienti (ACF o meta classico)
			$ingredienti_meta = get_post_meta( get_the_ID(), 'ingredienti', true );
			$ingredienti_acf  = function_exists('get_field') ? get_field( 'ingredienti', get_the_ID() ) : '';
			$ingredienti      = $ingredienti_acf ? $ingredienti_acf : $ingredienti_meta;

			if ( $ingredienti ) : ?>
				<div class="titolocpt">
					<?php
					if ( function_exists('pll_current_language') && pll_current_language() === 'it' ) {
						echo 'Ingredienti';
					} elseif ( function_exists('pll_current_language') && pll_current_language() === 'en' ) {
						echo 'Ingredients';
					} else {
						echo 'Ingredienti';
					}
					?>
				</div>
				<?php
				// Stampa contenuto ingredienti (consente HTML da ACF)
				echo wp_kses_post( $ingredienti );
			endif;
			?>
		</div>

		<div class="destra">
			<?php
			// Consigli (ACF o meta classico)
			$consigli_meta = get_post_meta( get_the_ID(), 'consigli', true );
			$consigli_acf  = function_exists('get_field') ? get_field( 'consigli', get_the_ID() ) : '';
			$consigli      = $consigli_acf ? $consigli_acf : $consigli_meta;

			if ( $consigli ) : ?>
				<div class="titolocpt">
					<?php
					if ( function_exists('pll_current_language') && pll_current_language() === 'it' ) {
						echo 'Consigli';
					} elseif ( function_exists('pll_current_language') && pll_current_language() === 'en' ) {
						echo 'Tips';
					} else {
						echo 'Consigli';
					}
					?>
				</div>
				<?php
				// Stampa contenuto consigli (consente HTML da ACF)
				echo wp_kses_post( $consigli );
			endif;
			?>
		</div>
	</div><!-- .contenitore -->

</div><!-- #primary -->

<?php if ( astra_page_layout() === 'right-sidebar' ) : ?>
	<?php get_sidebar(); ?>
<?php endif; ?>

<?php get_footer(); ?>