<?php

function child_enqueue_styles() {

wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() .

'/style.css' );
}
add_action( 'wp_enqueue_scripts', 'child_enqueue_styles' );


function post_type_piatti() {
register_post_type( 'piatti',
array( 'taxonomies' => array( 'category' , 'post_tag' ),
'labels' => array(
'name' => 'Piatti',
'singular_name' => 'Piatto',
'add_new' => 'Aggiungi Nuovo Piatto',
'add_new_item' => 'Aggiungi Nuovo Piatto',
'edit_item' => 'Modifica Piatto',
'new_item' => 'Nuovo Piatto',
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'hierarchical' => true,
'show_in_menu' => true,
'supports' => array(
'title',
'editor',
'author',
'thumbnail',
'excerpt',
'trackbacks',
'custom-fields',
'revisions',
'page-attributes'
),
)
);
}
add_action('init', 'post_type_piatti');


function category_add_cpt_to_archive ( $query ) {
    if( (is_category() || is_tag()) && $query->is_archive()
    && empty( $query->query_vars['suppress_filters'] ) ) {
    
    $query->set( 'post_type', 'any');
    
    }
    return $query;
    }
    add_filter( 'pre_get_posts', 'category_add_cpt_to_archive'
    );







function google_fonts() {
    wp_enqueue_style( 'google-fonts',
    'https://fonts.googleapis.com/css2?family=Courier+Prime:ital@0;1&family=Source+Code+Pro:ital,wght@0,200..900;1,200..900&display=swap', false );
    }
    add_action( 'wp_enqueue_scripts', 'google_fonts' );